(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3046,         92]*)
(*NotebookOutlinePosition[      3691,        114]*)
(*  CellTagsIndexPosition[      3647,        110]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(Clear[g, h, f, k]\)], "Input"],

Cell[BoxData[{
    \(g[t_] := 1 - Abs[t] /; Abs[t] < 1\), "\[IndentingNewLine]", 
    \(g[t_] := 0 /; Abs[t] \[GreaterEqual] 1\)}], "Input"],

Cell[BoxData[
    \(h[t_] := g[\((t - 4)\)/2] + g[\((t + 4)\)/2]\)], "Input"],

Cell[BoxData[
    \(Plot[h[t], {t, \(-7\), 7}, PlotStyle \[Rule] Thickness[ .0052], 
      Ticks \[Rule] {Automatic, {1}}, AspectRatio \[Rule]  .3]\)], "Input"],

Cell[BoxData[
    \(Display["\<triangulo2.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(f[t_] :=  .5\ Sin[
            2 \((t - 3)\) \[Pi]]/\((\[Pi]\ 2 \((t - 3)\))\)\)], "Input"],

Cell[BoxData[
    \(Plot[f[t], {t, \(-1\), 7}, PlotRange \[Rule] {All, {\(- .15\),  .55}}, 
      Ticks \[Rule] {Range[\(-1\), 6], { .5}}, 
      PlotStyle \[Rule] Thickness[ .005051]]\)], "Input"],

Cell[BoxData[
    \(Display["\<senoc.eps\>", %, "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    \(k[t_] := 3\ g[\((t + 2)\)/3] + 3  g[\((t - 2)\)/3]\)], "Input"],

Cell[BoxData[
    \(Plot[k[t], {t, \(-7\), 7}, PlotStyle \[Rule] Thickness[ .00505], 
      Ticks \[Rule] {Automatic, {3}}, 
      PlotRange \[Rule] {All, {\(- .2\), 3.2}}, 
      AspectRatio \[Rule]  .3]\)], "Input"],

Cell[BoxData[
    \(Display["\<triangulo3.eps\>", %, "\<EPS\>"]\)], "Input"]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1152}, {0, 781}},
WindowSize->{1144, 747},
WindowMargins->{{22, Automatic}, {Automatic, 1}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 50, 1, 30, "Input"],
Cell[1807, 54, 140, 2, 50, "Input"],
Cell[1950, 58, 77, 1, 30, "Input"],
Cell[2030, 61, 160, 2, 30, "Input"],
Cell[2193, 65, 76, 1, 30, "Input"],
Cell[2272, 68, 111, 2, 30, "Input"],
Cell[2386, 72, 197, 3, 30, "Input"],
Cell[2586, 77, 71, 1, 30, "Input"],
Cell[2660, 80, 83, 1, 30, "Input"],
Cell[2746, 83, 217, 4, 30, "Input"],
Cell[2966, 89, 76, 1, 30, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

